// $Id: scripts.js 1380 2009-11-10 10:10:36Z Yannick $

$(document).ready(function(){
	$("input[type=text],input[type=password],textarea").focus(function(){
		if ($(this).val()==$(this).attr("title"))
		{
			$(this).removeClass("blurred").val("");
		}
	}).blur(function(){
		if ($(this).val()=="")
		{
			$(this).addClass("blurred").val($(this).attr("title"));
		}
	}).each(function(){
		if ((!this.value) || (this.value==this.title))
		{
			$(this).addClass("blurred");
			this.value = this.title;
		}
	});

	$(".user-menu").each(function(){
		var user = $(this).closest(".user-simple");
		if ($(this).width()<user.width()) $(this).width(user.width());
		else user.width($(this).width());
		user.click(function(e){
			if (!e) e = window.event;
			if ($(this).hasClass("down"))
			{
				$(this).removeClass("down").find(".user-menu").hide();
			}
			else
			{
				$(this).addClass("down").find(".user-menu").show();
			}
			if (!$(e.target).hasClass(".user-menu-item")) return false;
		});
	});

	init_tabs();

	window.setTimeout("blink_init()",1000);
});

function blink_in()
{
	$(this).fadeTo(200,1,blink_out);
}

function blink_out()
{
	$(this).fadeTo(200,0.25,blink_in);
}

function blink_init()
{
	$(".blink img").fadeTo(200,0.25,blink_in);
}

function check_form(form)
{
	var ok = true;
	var names = [];

	$(form).find("input[type=text],input[type=password],input[type=radio],select,textarea").each(function(){
		if (ok)
		{
			if (this.type=="radio")
			{
				if ($.inArray(this.name,names)<0)
				{
					names = names.concat(this.name);
					if ($("input[name="+this.name+"]:checked").length==0)
					{
						if ($(this).closest("tr").hasClass("form-field-required"))
						{
							$(this).focus();
							ok = false;
						}
					}
				}
			}
			else if ((this.value==this.title) || (this.value==""))
			{
				if ($(this).closest("tr").hasClass("form-field-required"))
				{
					$(this).focus();
					ok = false;
				}
			}
		}
	});

	if (!ok) return false;

	$(form).find("input[type=text],input[type=password],textarea").each(function(){
		if (this.value==this.title)
		{
			this.value = "";
		}
	});

	return true;
}

function init_tabs()
{
	$(".tab").click(function(){
		var tab_set = $(this).closest(".tab-set");
		tab_set.find(".tab-page").hide().filter("#"+this.id.replace(/tab_/,"page_")).show();
		tab_set.find(".tab").removeClass("active");
		$(this).addClass("active");
	});
}
